package mole.entities.controlers 
{
	import mole.entities.CPlayer;
	import mole.entities.triggers.CLadder;
	import net.flashpunk.FP;
	import net.flashpunk.utils.Input;

	/**
	 * ...
	 * @author Cédric Liaudet
	 */
	public class CLadderControler implements IControler
	{
		/**
		 * Constructeur par défaut.
		 */
		public function CLadderControler(_Ladder:CLadder) 
		{
			m_Ladder = _Ladder;
			m_iVelocity = 0;
		}
		
		/**
		 * Callback de mise à jours du controlleur.
		 */
		public function update(_Player:CPlayer):void
		{
			_Player.y += m_iVelocity * FP.elapsed;
			
			// Monter/Descendre.
			if (Input.pressed("jump"))
			{
				m_iVelocity = -30;				
			}
			else if (Input.released("jump"))
			{
				m_iVelocity = 0;
				
				if (Input.check("down"))
				{
					m_iVelocity = 30;
				}
			}
			
			if (Input.pressed("down"))
			{
				m_iVelocity = 30;				
			}
			else if (Input.released("down"))
			{
				m_iVelocity = 0;
				
				if (Input.check("jump"))
				{
					m_iVelocity = -30;
				}
			}
			
			// Deplacement.
			if (Input.pressed("left"))
			{
				_Player.OnLeft();
			}
			else if (Input.released("left"))
			{				
				if (Input.check("right"))
				{
					_Player.OnRight();
				}
				else
					_Player.OnStop();
			}
			
			if (Input.pressed("right"))
			{
				_Player.OnRight();
			}
			else if (Input.released("right"))
			{
				if (Input.check("left"))
				{
					_Player.OnLeft();
				}
				else
					_Player.OnStop();
			}
			
			// On décroche le perso.
			if (Input.pressed("active"))
			{
				_Player.ReleaseExternalControler();
				_Player.OnFall();
			}
			
			// On vérifie que le joueur n'est pas tout en bas.
			if (m_Ladder.y + m_Ladder.height + 1 < _Player.y + _Player.height)
			{
				_Player.ReleaseExternalControler();
				_Player.OnFall();
			}
		}
		
		/**
		 * Renvoie la vitesse du controlleur.
		 * @return La vitesse du controlleur.
		 */
		public function GetSpeed():int
		{
			return 30;
		}
		
		private var m_iVelocity:int; 	///< Vitesse de déplacement.
		private var m_Ladder:CLadder; 	///< L'échelle.
	}

}